/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar.ui.ControlPanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ReadOnlyTable
extends JTable
implements MouseListener {
    int highlightedRow = -1;
    Color evenForeground;
    Color evenBackground;
    Color oddForeground;
    Color oddBackground;
    Color selectedForeground;
    Color selectedBackground;
    Color lightGray;
    private int numColumns;

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (n == this.highlightedRow) {
            component.setBackground(this.selectedBackground);
            component.setForeground(this.selectedForeground);
        } else if (n % 2 == 0) {
            component.setBackground(this.evenBackground);
            component.setForeground(this.evenForeground);
        } else {
            component.setBackground(this.oddBackground);
            component.setForeground(this.oddForeground);
        }
        return component;
    }

    public ReadOnlyTable(int n, int n2) {
        super(n, n2);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(this);
        this.numColumns = n2;
        this.initColors();
    }

    public ReadOnlyTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(this);
        this.numColumns = vector2.size();
        this.initColors();
    }

    public void updateTableData(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            for (int j = 0; j < this.numColumns; ++j) {
                Object e = vector.elementAt(j);
                super.setValueAt(e, i, j);
            }
        }
    }

    private void initColors() {
        this.evenForeground = Color.BLACK;
        this.evenBackground = new Color(230, 230, 230);
        this.oddForeground = Color.BLACK;
        this.oddBackground = this.getBackground();
        this.selectedForeground = Color.BLACK;
        this.selectedBackground = Color.YELLOW;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.highlightedRow = this.rowAtPoint(mouseEvent.getPoint());
        this.repaint();
    }

    public int getSelectedRow() {
        return this.highlightedRow;
    }

    public int[] getSelectedRows() {
        if (this.highlightedRow < 0) {
            return null;
        }
        int[] nArray = new int[]{this.highlightedRow};
        return nArray;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

