<?php /* $Id: nonusers_handler.php,v 1.30 2012/10/09 13:26:28 bbannon Exp $ */
include_once 'includes/init.php';
require_valide_referring_url();
load_user_layers();

$action    = getValue ( 'action' );
$delete    = getValue ( 'delete' );
$ispublic  = getValue ( 'ispublic' );
$nadmin    = getValue ( 'nadmin' );
$nfirstname= getValue ( 'nfirstname' );
$nid       = getValue ( 'nid' );
$nlastname = getValue ( 'nlastname' );
$old_admin = getValue ( 'old_admin' );

if ( ! $is_admin ) {
  echo print_not_auth ( true ) . print_trailer();
  exit;
}
$error = '';

if ( $action == 'Delete' || $action == $deleteStr ) {
  // delete this nonuser calendar
  $user = $nid;

  // Get event ids for all events this user is a participant.
  $events = get_users_event_ids ( $user );

  // Now count number of participants in each event...
  // If just 1, then save id to be deleted.
  $delete_em = array();
  foreach ( $events as $i ) {
    $res = dbi_execute ( 'SELECT COUNT( * ) FROM webcal_entry_user
      WHERE cal_id = ?', array ( $i ) );
    if ( $res ) {
      if ( $row = dbi_fetch_row ( $res ) && $row[0] == 1 )
        $delete_em[] = $i;

      dbi_free_result ( $res );
    }
  }
  // Now delete events that were just for this user
  foreach ( $delete_em as $i ) {
    dbi_execute ( 'DELETE FROM webcal_entry WHERE cal_id = ?', array ( $i ) );
  }

  // Delete user participation from events
  dbi_execute ( 'DELETE FROM webcal_entry_user WHERE cal_login = ?',
    array ( $user ) );
  // Delete any layers other users may have that point to this user.
  dbi_execute ( 'DELETE FROM webcal_user_layers WHERE cal_layeruser = ?',
    array ( $user ) );

  // Delete user
  if ( ! dbi_execute ( 'DELETE FROM webcal_nonuser_cals WHERE cal_login = ?',
      array ( $user ) ) )
    $error = db_error();
} else {
  if ( $action == 'Save' || $action == $saveStr ) {
    // Updating
    $sql_params = array();
    $sql = 'UPDATE webcal_nonuser_cals SET';
    if ( $nlastname ) {
      $sql .= ' cal_lastname = ?,';
      $sql_params[] = $nlastname;
    }
    if ( $nfirstname ) {
      $sql .= ' cal_firstname = ?,';
      $sql_params[] = $nfirstname;
    }
    $sql_params[] = $nadmin;
    $sql_params[] = $nid;
    if ( ! dbi_execute ( $sql . ' cal_admin = ? WHERE cal_login = ?',
        $sql_params ) )
      $error = db_error();
  } else {
    // Adding
    if ( preg_match ( '/^[\w]+$/', $nid ) ) {
      $nid = $NONUSER_PREFIX . $nid;
      if ( ! dbi_execute ( 'INSERT INTO webcal_nonuser_cals ( cal_login,
        cal_firstname, cal_lastname, cal_admin ) VALUES ( ?, ?, ?, ? )',
          array ( $nid, $nfirstname, $nlastname, $nadmin ) ) )
        $error = db_error();
    } else
      $error = translate ( 'Cal ID word chars only' );
  }
}
if ( empty ( $error ) )
  do_redirect ( 'nonusers.php' );

print_header();
echo print_error ( $error ) . print_trailer();

?>
