/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import us.k5n.webcalendar.ReminderDisplayer;
import us.k5n.webcalendar.ReminderList;
import us.k5n.webcalendar.WebCalendarClient;
import us.k5n.webcalendar.WebCalendarErrorException;

public class ReminderLoader
extends Thread {
    private WebCalendarClient client;
    URL url;
    String username;
    String password;
    int reloadMinutes;
    ReminderDisplayer display = null;
    HashMap done = null;

    public ReminderLoader(WebCalendarClient webCalendarClient, ReminderDisplayer reminderDisplayer, int n) {
        this.client = webCalendarClient;
        this.display = reminderDisplayer;
        this.reloadMinutes = n;
        this.done = new HashMap(13);
    }

    public ReminderList doUpdate() {
        try {
            String string = this.client.getReminders();
            if (string.indexOf("<reminders>") >= 0) {
                ReminderList reminderList = new ReminderList(string);
                return reminderList;
            }
            this.client.getMessageDisplayer().showError("Invalid data returned from server:\n\n" + string);
        }
        catch (MalformedURLException malformedURLException) {
            if (malformedURLException.toString().indexOf("login.php") >= 0) {
                this.client.getMessageDisplayer().showError("WebCalendar login required");
            } else {
                this.client.getMessageDisplayer().showError("Error getting data from server:\n" + malformedURLException.toString());
            }
        }
        catch (WebCalendarErrorException webCalendarErrorException) {
            System.err.println("WebCalendar Error: " + webCalendarErrorException.getMessage());
            this.client.getMessageDisplayer().showError("WebCalendar Error:\n" + webCalendarErrorException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("Exception getting reminders: " + exception.toString());
            exception.printStackTrace();
            if (exception.toString().indexOf("401") >= 0) {
                this.client.getMessageDisplayer().showError("Server requires HTTP authorization:\n" + exception.toString());
            }
            this.client.getMessageDisplayer().showError("Error getting data from server:\n" + exception.toString());
        }
        return null;
    }

    public void run() {
        while (true) {
            ReminderList reminderList;
            if ((reminderList = this.doUpdate()) != null) {
                this.display.setReminders(reminderList);
                this.display.interrupt();
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.reloadMinutes * 1000 * 60);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

