/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar.ui.ControlPanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import us.k5n.webcalendar.EventDisplayer;
import us.k5n.webcalendar.EventList;
import us.k5n.webcalendar.EventLoader;
import us.k5n.webcalendar.MessageDisplayer;
import us.k5n.webcalendar.Reminder;
import us.k5n.webcalendar.User;
import us.k5n.webcalendar.UserList;
import us.k5n.webcalendar.WebCalendarClient;
import us.k5n.webcalendar.WebCalendarClientListener;
import us.k5n.webcalendar.ui.ControlPanel.ActivityLogPanel;
import us.k5n.webcalendar.ui.ControlPanel.ReadOnlyTable;
import us.k5n.webcalendar.ui.ControlPanel.UnapprovedEventsPanel;
import us.k5n.webcalendar.ui.ControlPanel.UserDialog;
import us.k5n.webcalendar.ui.ControlPanel.UserListCellRenderer;
import us.k5n.webcalendar.ui.ControlPanel.UserListener;
import us.k5n.webcalendar.ui.ControlPanel.WebServiceLogPanel;

public class Main
implements MessageDisplayer,
EventDisplayer,
UserListener,
ActionListener,
WebCalendarClientListener {
    WebCalendarClient client = null;
    String appName = "WebCalendar ControlPanel";
    EventLoader eloader = null;
    EventList events = null;
    JFrame startupStatusFrame = null;
    JFrame toplevel = null;
    JLabel dateRange = null;
    JLabel statusMessage = null;
    Calendar startDate = null;
    Calendar endDate = null;
    JPanel userTab = null;
    JList userTabUserList = null;
    ReadOnlyTable logTable = null;
    WebServiceLogPanel logPanel = null;

    public void showReminder(Reminder reminder) {
        JOptionPane.showMessageDialog(this.toplevel, reminder.toString());
    }

    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this.toplevel, string);
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(this.toplevel, string, this.appName + " Error", 2);
    }

    public void storeEvents(EventList eventList) {
        this.events = eventList;
        if (this.startupStatusFrame != null) {
            this.startupStatusFrame.dispose();
            this.startupStatusFrame = null;
        }
        if (this.toplevel == null) {
            this.createWindow(this.client);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < eventList.size(); ++i) {
            stringBuffer.append(eventList.eventAt(i).toString() + "\n");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("No events");
        }
        this.dateRange.setText("Date range: " + (this.startDate.get(2) + 1) + '/' + this.startDate.get(5) + '/' + this.startDate.get(1) + " - " + (this.endDate.get(2) + 1) + '/' + this.endDate.get(5) + '/' + this.endDate.get(1));
    }

    public void createWindow(WebCalendarClient webCalendarClient) {
        this.createWindow(700, 500, webCalendarClient);
    }

    public void createWindow(int n, int n2, WebCalendarClient webCalendarClient) {
        this.client = webCalendarClient;
        this.logPanel = new WebServiceLogPanel();
        this.toplevel = new JFrame(this.appName);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        this.toplevel.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        String string = this.appName + " / " + webCalendarClient.getCalendarName() + " /" + webCalendarClient.getServerName();
        this.statusMessage = new JLabel(string);
        jPanel.add((Component)this.statusMessage, "South");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        this.userTab = this.createUserTab();
        jTabbedPane.addTab("Users", this.userTab);
        jTabbedPane.addTab("Activity Log", new ActivityLogPanel(webCalendarClient));
        jTabbedPane.addTab("Unapproved Events", new UnapprovedEventsPanel(webCalendarClient));
        jTabbedPane.addTab("Web Service Log", this.logPanel);
        Container container = this.toplevel.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        container.add(jPanel);
        this.toplevel.setDefaultCloseOperation(3);
        this.toplevel.setSize(n, n2);
        this.toplevel.setVisible(true);
    }

    JPanel createUserTab() {
        final Main main = this;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JButton jButton = new JButton("Refresh");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.updateUserList();
            }
        });
        jButton = new JButton("Add...");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserDialog userDialog = new UserDialog(Main.this.client, Main.this.toplevel, 2, main);
            }
        });
        jButton = new JButton("Import...");
        jButton.setEnabled(false);
        jPanel2.add(jButton);
        jButton = new JButton("Edit...");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                User user = (User)Main.this.userTabUserList.getSelectedValue();
                if (user == null) {
                    Main.this.showError("You must select a user to edit.");
                } else {
                    UserDialog userDialog = new UserDialog(Main.this.client, Main.this.toplevel, 1, main, user);
                }
            }
        });
        jButton = new JButton("Delete");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = Main.this.userTabUserList.getSelectedValues();
                if (objectArray.length == 0) {
                    Main.this.client.showError("You must select at\nleast one user.");
                } else if (objectArray.length > 1) {
                    Main.this.client.showError("You must select\nonly one user.");
                } else {
                    User user = (User)objectArray[0];
                    Object[] objectArray2 = new String[]{"Delete", "Cancel"};
                    int n = JOptionPane.showOptionDialog(Main.this.toplevel, "Are you sure you want to\ndelete the following user?\n\n" + user.toString() + "\n\nThis will delete this user's\ndata also (events, etc.)", "Confirm", 0, 3, null, objectArray2, objectArray2[1]);
                    if (n == 0) {
                        System.out.println("Delete");
                        Main.this.client.deleteUser(user);
                        Main.this.client.showMessage("The following user was deleted:\n\n" + user.toString());
                        Main.this.updateUserList();
                    }
                }
            }
        });
        jPanel.add((Component)jPanel2, "South");
        UserList userList = null;
        try {
            String string = this.client.query("ws/get_users.php");
            userList = new UserList(string, "users");
        }
        catch (Exception exception) {
            System.err.println("Exception getting users: " + exception);
            exception.printStackTrace();
        }
        this.userTabUserList = new JList(userList);
        this.userTabUserList.setCellRenderer(new UserListCellRenderer());
        this.userTabUserList.setSelectionMode(0);
        jPanel.add((Component)this.userTabUserList, "Center");
        return jPanel;
    }

    public void updateUserList() {
        UserList userList = null;
        try {
            String string = this.client.query("ws/get_users.php");
            userList = new UserList(string, "users");
        }
        catch (Exception exception) {
            System.err.println("Exception getting users: " + exception);
            exception.printStackTrace();
        }
        this.userTabUserList.setListData(userList);
    }

    public JDialog createUserModDialog(JFrame jFrame) {
        return new UserDialog(this.client, jFrame, 2, this);
    }

    private void reloadEvents() {
        this.eloader.setStartDate(this.startDate);
        this.eloader.setEndDate(this.endDate);
        this.eloader.interrupt();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Exit".equals(actionEvent.getActionCommand())) {
            System.exit(0);
        } else {
            System.out.println("action command: " + actionEvent.getActionCommand());
            System.out.println("paramString: " + actionEvent.paramString());
        }
    }

    public static void fatalError(String string) {
        System.err.println(string);
        JOptionPane.showMessageDialog(null, string, "WebCalendar ControlPanel Error", 2);
        System.exit(1);
    }

    public void outgoingRequest(String string) {
        if (this.logPanel != null) {
            this.logPanel.appendRequest(string);
        }
    }

    public void incomingResult(String string) {
        if (this.logPanel != null) {
            this.logPanel.appendResposne(string);
        }
    }

    public static String promptUser(String string) {
        String string2 = (String)JOptionPane.showInputDialog(null, string, "WebCalendar ControlPanel", -1, null, null, "");
        return string2;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string = null;
        Object var2_2 = null;
        Object var3_3 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        WebCalendarClient webCalendarClient = null;
        System.out.println("WebCalendar ControlPanel version: $Id: Main.java,v 1.8 2006/06/09 21:00:59 cknudsen Exp $");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-url=")) {
                string = stringArray[i].substring(5);
                continue;
            }
            if (stringArray[i].startsWith("-user=")) {
                string2 = stringArray[i].substring(6);
                continue;
            }
            if (stringArray[i].startsWith("-username=")) {
                string2 = stringArray[i].substring(10);
                continue;
            }
            if (stringArray[i].startsWith("-password=")) {
                string3 = stringArray[i].substring(10);
                continue;
            }
            if (stringArray[i].startsWith("-passwd=")) {
                string3 = stringArray[i].substring(8);
                continue;
            }
            if (stringArray[i].startsWith("-httpuser=")) {
                string4 = stringArray[i].substring(10);
                continue;
            }
            if (stringArray[i].startsWith("-httpusername=")) {
                string4 = stringArray[i].substring(14);
                continue;
            }
            if (stringArray[i].startsWith("-httppasswd=")) {
                string5 = stringArray[i].substring(12);
                continue;
            }
            if (stringArray[i].startsWith("-httppassword=")) {
                string5 = stringArray[i].substring(14);
                continue;
            }
            object2 = new StringBuffer(128);
            ((StringBuffer)object2).append("Invalid argument '" + stringArray[i] + "'\n");
            ((StringBuffer)object2).append("Usage: java Main [options]\n");
            ((StringBuffer)object2).append("  options:\n");
            ((StringBuffer)object2).append("    -url=XXX\n");
            ((StringBuffer)object2).append("    -username=XXX\n");
            ((StringBuffer)object2).append("    -passwd=XXX\n");
            ((StringBuffer)object2).append("    -httpusername=XXX\n");
            ((StringBuffer)object2).append("    -httppasswd=XXX\n");
            object = ((StringBuffer)object2).toString();
            Main.fatalError((String)object);
        }
        if (string == null) {
            Main.fatalError("No URL specified.");
        }
        if (!string.endsWith("/")) {
            Main.fatalError("Invalid WebCalendar URL.\nShould be base URL (ends with '/')");
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            Main.fatalError("Invalid URL: " + string);
        }
        System.out.println("username: " + string4);
        System.out.println("wcUsername: " + string2);
        while (string4 != null && (string5 == null || string5.length() == 0)) {
            string5 = Main.promptUser("Your server requires HTTP authentication.\n\nPlease enter the password\nfor user \"" + string4 + "\".\n\nPassword:");
        }
        if (!(string2 != null && string2.length() != 0 || string4 != null && string4.length() != 0)) {
            while (string2 == null || string2.length() == 0) {
                string2 = Main.promptUser("Please enter your\nWebCalendar username.\n\nLogin:");
            }
        }
        while (string2 != null && (string3 == null || string3.length() == 0)) {
            string3 = Main.promptUser("Please enter the password\nfor user \"" + string2 + "\".\n\nPassword:");
        }
        webCalendarClient = new WebCalendarClient(uRL);
        object2 = new Main();
        webCalendarClient.setMessageDisplayer((MessageDisplayer)object2);
        webCalendarClient.addListener((WebCalendarClientListener)object2);
        ((Main)object2).startupStatusFrame = new JFrame(((Main)object2).appName);
        object = new JLabel("Connecting to WebCalendar server...");
        ((Main)object2).startupStatusFrame.getContentPane().add((Component)object);
        ((Main)object2).startupStatusFrame.setDefaultCloseOperation(3);
        ((Main)object2).startupStatusFrame.pack();
        ((Main)object2).startupStatusFrame.setLocation(300, 300);
        ((Main)object2).startupStatusFrame.setVisible(true);
        ((Main)object2).startupStatusFrame.toFront();
        if (string4 != null) {
            webCalendarClient.setHttpAuthentication(string4, string5);
        }
        if (string2 != null) {
            webCalendarClient.setWebAuthentication(string2, string3);
            try {
                ((JLabel)object).setText("Logging in to server...");
                if (!webCalendarClient.login()) {
                    Main.fatalError("Invalid WebCalendar login");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Main.fatalError("Error on WebCalendar login: " + exception.toString());
            }
        }
        if (((Main)object2).startupStatusFrame != null) {
            ((Main)object2).startupStatusFrame.dispose();
            ((Main)object2).startupStatusFrame = null;
        }
        ((Main)object2).createWindow(700, 500, webCalendarClient);
    }
}

