#!/usr/local/bin/php -q
<?php
/*
 * @author Craig Knudsen <cknudsen@cknudsen.com>
 * @copyright Craig Knudsen, <cknudsen@cknudsen.com>, http://www.k5n.us/cknudsen
 * @license http://www.gnu.org/licenses/gpl.html GNU GPL
 * @version $Id: reload_remotes.php,v 1.21 2012/11/14 00:57:10 bbannon Exp $
 * @package WebCalendar
 */
/**
 * Page Description:
 * This is a command-line script that will reload all user's remote calendars.
 *
 * Usage:
 * php reload_remotes.php
 *
 * Setup:
 * This script should be setup to run periodically on your system.
 * You should not run this more a once per hour for performance reasons
 *
 * To set this up in cron, add a line like the following in your crontab
 * to run it every hour:
 *   1 * * * * php /some/path/here/reload_remotes.php
 * Of course, change the path to where this script lives. If the PHP binary is
 * not in your $PATH, you may also need to provide the full path to "php".
 * On Linux, just type crontab -e to edit your crontab.
 *
 * If you're a Windows user, you'll either need to find a cron clone
 * for Windows (they're out there) or use the Windows Task Scheduler.
 * (See docs/WebCalendar-SysAdmin.html for instructions.)
 *
 * Comments:
 * You will need access to the PHP binary (command-line) rather than the
 * module-based version that is typically installed for use with a web server.
 *
 * If running this script from the command line generates PHP warnings,
 * you can disable error_reporting by adding
 * "-d error_reporting=0" to the command line:
 *   php -d error_reporting=0 /some/path/here/tools/reload_remotes.php
 *
 ******************************************************************** */
// Load include files.
// If you have moved this script out of the WebCalendar directory,
// which you probably should do since it would be better for security reasons,
// you would need to change __WC_INCLUDEDIR to point to the
// webcalendar include directory.

define( '__WC_BASEDIR', '../' ); // Points to the base WebCalendar directory
                 // relative to current working directory.
define( '__WC_INCLUDEDIR', __WC_BASEDIR . 'includes/' );
define( '__WC_CLASSDIR', __WC_INCLUDEDIR . 'classes/' );
$old_path= ini_get ( 'include_path' );
$delim   = ( strpos ( $old_path, ';' ) ? ';' : ':' );
ini_set ( 'include_path', $old_path . $delim . __WC_INCLUDEDIR . $delim );

foreach( array(
    'config',
    'dbi4php',
    'formvars',
    'functions',
    'translate',
    'xcal',
  ) as $i ) {
  include_once __WC_INCLUDEDIR . $i . '.php';
}
require_once __WC_CLASSDIR . 'WebCalendar.class';

$WebCalendar = new WebCalendar( __FILE__ );
$WebCalendar->initializeFirstPhase();

include __WC_INCLUDEDIR . $user_inc;

$WebCalendar->initializeSecondPhase();
// Used for hCal parsing.
require_once __WC_CLASSDIR . 'hKit/hkit.class.php';

$debug = false; // Set to true to print debug info...

// Establish a database connection.
$c = dbi_connect ( $db_host, $db_login, $db_password, $db_database, true );
if ( ! $c ) {
  echo translate ( 'Error connecting to DB' ) . ' ' . dbi_error();
  exit;
}

load_global_settings();
$WebCalendar->setLanguage();

if ( $debug )
  echo "<br>\n" . translate( 'Include Path' )
   . ' =' . ini_get( 'include_path' ) . "<br>\n";

if ( $REMOTES_ENABLED == 'Y' ) {
  $res = dbi_execute ( 'SELECT cal_login, cal_url, cal_admin
    FROM webcal_nonuser_cals WHERE cal_url IS NOT NULL' );
  $cnt = 0;
  if ( $res ) {
    while ( $row = dbi_fetch_row ( $res ) ) {
      $data = array();
      $cnt++;
      $calUser = $row[0];
      $cal_url = $row[1];
      $login = $row[2];
      $overwrite = true;
      $type = 'remoteics';
      $data = parse_ical ( $cal_url, $type );
      // TODO it may be a vcs file
      // if ( count ( $data ) == 0 ) {
      // $data = parse_vcal ( $cal_url );
      // }
      // we may be processing an hCalendar
      if ( count ( $data ) == 0 && function_exists ( 'simplexml_load_string' ) ) {
        $h = new hKit;
        $h->tidy_mode = 'proxy';
        $result = $h->getByURL ( 'hcal', $cal_url );
        $type = 'hcal';
        $data = parse_hcal ( $result, $type );
      }
      if ( count ( $data ) && empty ( $errormsg ) ) {
        // delete existing events
        if ( $debug )
          echo "<br>\n" . translate( 'Deleting events for' )
           . ": $calUser<br>\n";
        delete_events ( $calUser );
        // import new events
        if ( $debug )
          echo translate( 'Importing events for' ) . ": $calUser<br>\n"
           . translate( 'From' ) . ": $cal_url<br>\n";
        import_data ( $data, $overwrite, $type );
        if ( $debug )
          echo translate ( 'Events successfully imported' )
           . " $count_suc<br><br>\n";
      } else { // we didn't receive any data and/or there was an error
        if ( ! empty ( $errormsg ) )
          echo $errormsg . "<br>\n";

        if ( count ( $data ) == 0 )
          echo "<br>\n" . translate( 'No data returned from' )
           . ":  $cal_url<br>\n" . translate( 'for non-user calendar' )
           . ":  $calUser<br>\n";
      }
    }
    dbi_free_result ( $res );
  }
  if ( $cnt == 0 )
    echo "<br>\n" . translate( 'No Remote Calendars found' );
} else
  echo "<br>\n" . translate( 'Remote Calendars not enabled' );
// just in case
$login = '';
/**
 * delete_events (needs description)
 */
function delete_events ( $nid ) {
  // Get event ids for all events this user is a participant
  $events = get_users_event_ids ( $nid );

  // Now count number of participants in each event...
  // If just 1, then save id to be deleted
  $delete_em = array();
  foreach ( $events as $i ) {
    $res = dbi_execute ( 'SELECT COUNT( * ) FROM webcal_entry_user
      WHERE cal_id = ?', array ( $i ) );
    if ( $res ) {
      if ( $row = dbi_fetch_row ( $res ) ) {
        if ( $row[0] == 1 )
          $delete_em[] = $i;
      }
      dbi_free_result ( $res );
    }
  }
  // Now delete events that were just for this user
  foreach ( $delete_em as $i ) {
    foreach ( array (
        'webcal_blob',
        'webcal_entry',
        'webcal_entry_ext_user',
        'webcal_entry_repeats',
        'webcal_entry_repeats_not',
        'webcal_import_data',
        'webcal_reminders',
        'webcal_site_extras' ) as $db ) {
      dbi_execute ( 'DELETE FROM ' . $db . ' WHERE cal_id = ?', array ( $i ) );
    }
    dbi_execute ( 'DELETE FROM webcal_entry_log WHERE cal_entry_id = ?', array ( $i ) );
  }
  // Delete user participation from events
  dbi_execute ( 'DELETE FROM webcal_entry_user WHERE cal_login = ?', array ( $nid ) );
}

?>
